using System;
using System.Text;
using System.Management.Automation;
using System.Management.Automation.Provider;
using System.Management;
using System.Net.NetworkInformation;

namespace de.ITVisions.PowerShell
{


 [Cmdlet("Test", "Progress")]
 public class TestProgressCommand : PSCmdlet
 {
  //   [Parameter()]
  //[Parameter(Position = 0, ValueFromPipeline = true)]

  [Parameter(Position = 0, ValueFromPipeline = true)]
  public string Computer = ".";

  protected override void EndProcessing()
  {
   for (int i = 0; i < 1000; i++)
   {
    if (i % 10 == 0)
    {
     ProgressRecord pr = new ProgressRecord(1, "Count", "Current Counter = " + i.ToString() + " (" + i / 10 + "%)");
     pr.PercentComplete = i / 10 ;
     WriteProgress(pr);
    }
    System.Threading.Thread.Sleep(10);
   }
  }

  protected override void ProcessRecord()
  {

  }

  protected override void StopProcessing()
  {

  
  }

 }
}
